/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.attributes;

import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;

public class AttributeOneOf
extends AttributeSelector {
    String value;
    String[] values;

    public AttributeOneOf(String name, String value) {
        this.setName(name);
        this.value = value;
        this.values = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.values = null;
    }

    public boolean canApply(Selector other) {
        if (other instanceof AttributeAny) {
            return true;
        }
        if (other instanceof AttributeExact) {
            String exact = ((AttributeExact)other).getValue();
            return this.value.equals(exact);
        }
        if (other instanceof AttributeOneOf) {
            return true;
        }
        return other instanceof AttributeBegin;
    }

    public String toString() {
        return "[" + this.getName() + "~=\"" + this.value + "\"]";
    }

    private String[] computeValues() {
        this.values = this.value.split("\\s");
        return this.values;
    }

    public void applyAttribute(ApplContext ac, AttributeSelector attr) {
        String name = this.getName();
        if (name.equals(attr.getName())) {
            if (this.values == null) {
                this.computeValues();
            }
            if (attr instanceof AttributeExact) {
                String val = ((AttributeExact)attr).getValue();
                boolean ok = false;
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    ok = val.equals(this.values[i]);
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeBegin) {
                String val = ((AttributeBegin)attr).getValue();
                boolean ok = false;
                String pval = val + '-';
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    ok = this.values[i].equals(val) || this.values[i].startsWith(pval);
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeStart) {
                String val = ((AttributeStart)attr).getValue();
                boolean ok = false;
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    ok = this.values[i].startsWith(val);
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeSubstr) {
                String val = ((AttributeSubstr)attr).getValue();
                boolean ok = false;
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    ok = this.values[i].indexOf(val) >= 0;
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeSuffix) {
                String val = ((AttributeSuffix)attr).getValue();
                boolean ok = false;
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    ok = this.values[i].endsWith(val);
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeOneOf) {
                AttributeOneOf otherattr = (AttributeOneOf)attr;
                String[] othervalues = otherattr.values;
                if (othervalues == null) {
                    othervalues = otherattr.computeValues();
                }
                boolean ok = false;
                for (int i = 0; !ok && i < this.values.length; ++i) {
                    for (int j = 0; !ok && j < othervalues.length; ++j) {
                        ok = this.values[i].equals(othervalues[j]);
                    }
                }
                if (!ok) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            }
        }
    }
}

